<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile DEQMSummaryMeasureReportProfile
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:MeasureReport</sch:title>
    <sch:rule context="f:MeasureReport">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-measureScoring']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-measureScoring': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-reportingVendor']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-reportingVendor': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-certificationIdentifier']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-certificationIdentifier': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/measurereport-category']) &gt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/measurereport-category': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/measurereport-category']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/measurereport-category': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/score']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/score': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:reporter</sch:title>
    <sch:rule context="f:MeasureReport/f:reporter">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-reporterGroup']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-reporterGroup': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:group/f:measureScore</sch:title>
    <sch:rule context="f:MeasureReport/f:group/f:measureScore">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-alternateScoreType']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-alternateScoreType': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:group/f:stratifier/f:stratum</sch:title>
    <sch:rule context="f:MeasureReport/f:group/f:stratifier/f:stratum">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/score']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/score': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:MeasureReport/f:group/f:stratifier/f:stratum/f:measureScore</sch:title>
    <sch:rule context="f:MeasureReport/f:group/f:stratifier/f:stratum/f:measureScore">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-alternateScoreType']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-alternateScoreType': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
