<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile CQFMCompositeMeasure
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:Measure</sch:title>
    <sch:rule context="f:Measure">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-allocation']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-allocation': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-scoringUnit']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-scoringUnit': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/lob']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/lob': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:improvementNotation) &lt;= 0">improvementNotation: maximum cardinality of 'improvementNotation' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Measure/f:relatedArtifact</sch:title>
    <sch:rule context="f:Measure/f:relatedArtifact">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-groupId']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-groupId': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-weight']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-weight': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status']) &gt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Measure/f:group</sch:title>
    <sch:rule context="f:Measure/f:group">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-compositeScoring']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-compositeScoring': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-scoringUnit']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-scoringUnit': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Measure/f:group/f:extension</sch:title>
    <sch:rule context="f:Measure/f:group/f:extension">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-groupId']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-groupId': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-weight']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-weight': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
