
|Term|Definition|
|---|---|
|Administrative Cost|Administrative costs are the expenses associated with operating a health plan and exclude the cost of claims. They are largely driven by staffing, technology, and operational processes.|
|Adjustments|An adjustment is a request to reprocess the claim after taking into consideration some new or changed information. The information provided on the original claim is either corrected or supplemented.|
|Alternative Payment Models (APMs)|Alternative payment models deviate from traditional fee-for-service (FFS) payment, insofar as they adjust FFS payments to account for performance on cost and quality metrics, or insofar as they use population-based payments that are linked to quality performance. [source](http://hcp-lan.org/workproducts/ds-whitepaper-final.pdf)|
|Average Risk Score|Average risk score for the population, which is a numeric score where a higher score indicates a riskier population on average. Note that within that population, each patient also has risk score, which helps to know which patient is riskier.|
|Bonus Amount|VBP models may reward quality and cost savings separately, or they may link them. When treated separately, there is a discrete quality bonus, irrespective of the provider’s performance relative to their financial benchmark.|
|Brand|Brand (for example Blue vs. non-blue)|
|Capitation|A fixed amount of money per patient per unit of time paid in advance to the physician (or health care provider) for the delivery of health care services. The actual amount of money paid is determined by the ranges of services that are provided, the number of patients involved, and the period of time during which the services are provided.[source](https://www.acponline.org/about-acp/about-internal-medicine/career-paths/residency-career-counseling/resident-career-counseling-guidance-and-tips/understanding-capitation)|
|Care Coordination Fee (CCF)|Care coordination fees are the Per Member Per Month (PMPM) payments based on the number of patients that are assigned to primary care physicians|
|Incurred but not reported (IBNR)|A type of reserve account used in the insurance industry as the provision for claims and/or events that have transpired, but have not yet been reported to an insurance company|
|Fee-for-Service (FFS)|Traditional health care payment models, in which providers are paid separately for each service they deliver.|
|Financial Benchmark|A set, risk-adjusted dollar amount typically determined by historical fee-for-service spend, market-based trends, or other methods that is used to measure financial performance in VBP Models. Programs using a financial benchmark most closely align with the HCPLAN Categories 3 and 4. (source: [CAQH CORE Framework for Semantic Interoperability in Value-based Payments](https://www.caqh.org/hubfs/CORE/CORE_Framework_for_Semantic_Interoperability_in_Value_Based_Payments_vSI.1.0.pdf))|
|Gating|Meet a performance threshold for other terms to apply. Establish a performance target or “gate” that must be cleared before an accountable provider organization can receive rewards.|
|Inpatient Claims|Bills submitted for program level (facility-based) services |
|Line of Business (LOB)|Commercial, Medicaid, Medicare, etc.|
|Measure sets|A collection of measures that are mutually reinforcing to produce positive outcomes for a defined patient population.|
|Measure Targets|The performance rates that accountable provider organizations need to achieve to receive different levels of rewards and penalties|
|Medical Cost Target|Projected medical cost|
|Medical Loss Ratio (MLR)|The share of total health care premiums spent on medical claims.|
|Medical Loss Ratio Target (MLRT)|Actuarial estimate of MLR|
|Population-Based Payment Model|A payment model in which a provider organization is given a population-based global budget or payment and accepts accountability for managing the total cost of care, quality, and outcomes for a defined patient population across the full continuum of care. They are payment models in Categories 3 and 4 of the HCPLAN's APM Framework.|
|Product|A product is a discrete package of health insurance coverage benefits that are offered using a particular product network type (such as health maintenance organization, preferred provider organization, exclusive provider organization, point of service, or indemnity) within a service area.|
|Quality Incentive payment|A type of payment that is tied to the achievement of performance or reporting on a set of established quality measures.|
|Revenue Per Member Per Month (PMPM)|Revenue per member per month|
|Revenue|Total revenues earned, which includes premiums and other resources that a payer receives.|
|Runout|Runout is an administrative period of time following the end of the plan year that allows a participant extra time to submit eligible claims incurred during the plan year.|
|Measure Scoring|The scoring type of the measure, such as proportion, ratio, continuous-variable, cohort, and composite.|
|Service through Date|Absolute cutoff date for data included in performance period|
|Shared Savings/Loss|Projected expenses vs. actual claims received|
|Total Cost of Care (TCOC)|A broad indicator of spending for a given population (i.e., payments from payer to provider organizations). In the context of population-based payment (PBP) models, in which provider accountability spans the full continuum of care, TCOC includes all spending associated with caring for a defined population, including provider and facility fees, inpatient and ambulatory care, pharmacy, behavioral health, laboratory, imaging, and other ancillary services.|
|Total Cost PMPM|Total of Medical and Prescription Cost/Member Months|
|Total Medicare Advantage (MA) Support Revenue|Premiums collected from Medicare Advantage|
|Total Revenue|Premiums the payer is collecting|
|Variance Cost|Actual costs/Projected costs|
|Withhold|An amount of payment that is withheld and may have additional measurement thresholds to receive this payment|
|Value-based Purchasing (VBP)|Linking provider payments to improved performance by health care providers. This form of payment holds health care providers accountable for both the cost and quality of care they provide. It attempts to reduce inappropriate care and to identify and reward the best-performing providers. [source](https://www.healthcare.gov/glossary/value-based-purchasing-vbp/). VBP may also be referred to as value-based contracting, value-based payments, and alternative payment models|
{: .grid}


---

{% include link-list.md %}