
### Package File

The following package file includes a Node Package Manager ([NPM](https://hl7.org/fhir/packages.html)) package file used by many of the FHIR tools. It contains all the value sets, profiles, extensions, list of pages and URLs, etc., that are defined as part of this version of the implementation guide (IG). This file should be the first choice whenever generating any implementation artifacts since it contains all of the rules about what makes the profiles valid. Implementers will still need to be familiar with the content of the specification and profiles that apply in order to make a conformant implementation. See the [Validating Resources]({{site.data.fhir.path}}validation.html) documentation in FHIR.

- [Package](package.tgz){::download="true"}

### Downloadable Copy of Entire Specification

A downloadable version of this IG is available so it can be hosted locally:

- [Downloadable Copy](full-ig.zip)

### Examples

All the examples that are used in this IG are available for download:

- [XML](examples.xml.zip)
- [JSON](examples.json.zip)

### Schematrons

Schematrons are available for download:

- [Schematrons](schematrons.zip)

#### Cross Version Analysis

{% include cross-version-analysis.xhtml %}

#### Dependency Table

{% include dependency-table.xhtml %}

#### Globals Table

{% include globals-table.xhtml %}

#### IP Statements

{% include ip-statements.xhtml %}
